<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="card custom-card">
                <div class="card-header justify-content-between">
                    <div class="card-title">DATA Performa Landingpage</div>
                    <div class="d-flex flex-wrap gap-2">
                        <form method="GET" action="<?php echo e(route('landingpages.performance')); ?>">
                            <div class="d-flex flex-wrap gap-2">
                                <!-- Month Filter -->
                                <div>
                                    <select name="month" class="form-control form-control-sm" id="monthFilter">
                                        <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($month); ?>" <?php echo e((request('month', $selectedMonth) == $month) ? 'selected' : ''); ?>>
                                                <?php echo e(\Carbon\Carbon::create(null, $month)->format('F')); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                
                                <!-- Year Filter -->
                                <div>
                                    <select name="year" class="form-control form-control-sm" id="yearFilter">
                                        <?php $__currentLoopData = range(\Carbon\Carbon::now()->year - 5, \Carbon\Carbon::now()->year); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <!-- Adjust year range if needed -->
                                            <option value="<?php echo e($year); ?>" <?php echo e((request('year', $selectedYear) == $year) ? 'selected' : ''); ?>>
                                                <?php echo e($year); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                        
                                <!-- Submit Button -->
                                <div>
                                    <button type="submit" class="btn btn-primary btn-sm">Filter</button>
                                </div>
                            </div>
                        </form>
                        
                        
                    </div>
                </div>
                
                <div class="card-body p-2">
                    <div class="container">
                        <div class="scroll-container">
                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    // Initialize totals for each landing page
                                    $totalSpent = 0;
                                    $totalContact = 0;
                                    $totalCPContact = 0;
                                    $performanceCount = 0;
                                ?>

                                <div class="card-container">
                                    <div class="card">
                                        <div class="card-header d-flex justify-content-between align-items-center sticky-header">
                                            <h5 class="mb-0"><?php echo e($item['code']); ?></h5>
                                            <a href="<?php echo e($item['link']); ?>" target="_blank" class="btn btn-primary btn-sm">Lihat Landingpage</a>
                                        </div>
                                        <div class="card-header d-flex flex-column align-items-start sticky-header">

                                            <?php
                                                // Initialize totals for each landing page
                                                $totalSpent = 0;
                                                $totalContact = 0;
                                                $totalCPContact = 0;
                                                $performanceCount = 0;
                                            ?>

                                            <?php $__currentLoopData = $item['performances']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $tanggalDetail = \Carbon\Carbon::parse($detail['tanggal']);
                                                    $startOfMonth = \Carbon\Carbon::now()->startOfMonth();
                                                    $endOfMonth = \Carbon\Carbon::now()->endOfMonth();
                                                ?>

                                                <?php if($tanggalDetail->between($startOfMonth, $endOfMonth)): ?>
                                                    <?php
                                                        // Calculate totals for spending and contacts
                                                        $totalSpent += (float) $detail['amount_spent'];
                                                        $totalContact += (int) $detail['contact'] ?? 0;
                                                        $totalCPContact += (float) $detail['total_performance'];
                                                        $performanceCount++;
                                                    ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <!-- Data Summary (below the code and link) -->
                                            <div class="summary" style="margin-top: 8px;">
                                                <p style="font-size: 12px; font-weight: 400; margin-bottom: 2px;">Spending LP: Rp
                                                    <?php echo e(number_format($totalSpent, 0, ',', '.')); ?></p>
                                                <p style="font-size: 12px; font-weight: 400; margin-bottom: 2px;">AVG CPC: Rp
                                                    <?php echo e($performanceCount > 0 ? number_format($totalSpent / $performanceCount, 0, ',', '.') : '-'); ?>

                                                </p>
                                                <p style="font-size: 12px; font-weight: 400; margin-bottom: 2px;">Jumlah Contact: <?php echo e($totalContact); ?></p>
                                            </div>
                                            
                                        </div>


                                        <div class="card-body table-scroll">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Tanggal</th>
                                                        <th>CPContact</th>
                                                        <th>Kontak</th>
                                                        <th>Spent</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $item['performances']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $tanggalDetail = \Carbon\Carbon::parse($detail['tanggal']);
                                                            $startOfMonth = \Carbon\Carbon::now()->startOfMonth();
                                                            $endOfMonth = \Carbon\Carbon::now()->endOfMonth();
                                                        ?>

                                                        
                                                            <?php
                                                                // Calculate totals for spending and contacts
                                                                $totalSpent += (float) $detail['amount_spent'];
                                                                $totalContact += (int) $detail['contact'] ?? 0;
                                                                $totalCPContact += (float) $detail['total_performance'];
                                                                $performanceCount++;
                                                            ?>
                                                            <tr>
                                                                <td><?php echo e($detail['tanggal']); ?></td>
                                                                <td><?php echo e(number_format(round((float) $detail['total_performance']), 0, ',', '.')); ?>

                                                                </td>
                                                                <td><?php echo e($detail['contact'] ?? '-'); ?></td>
                                                                <td>Rp
                                                                    <?php echo e(number_format((float) $detail['amount_spent'], 0, ',', '.')); ?>

                                                                </td>
                                                            </tr>
                                                        
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .scroll-container {
            display: flex;
            overflow-x: auto;
            padding-bottom: 20px;
            gap: 15px;
        }

        .card-container {
            flex-shrink: 0;
            width: 600px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .sticky-header {
            background-color: #f7f7f7;
            padding: 10px;
            font-weight: bold;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .table-scroll {
            max-height: 500px;
            overflow-y: auto;
            padding: 10px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }

        .table th,
        .table td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .table th {
            background-color: #f4f4f4;
            text-align: left;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/app-senesa.com/analytics-project/resources/views/landingpage/performance.blade.php ENDPATH**/ ?>